/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLSHELL
#define WAYLANDBACKEND_WLSHELL 1

#include <string>
#include <wayland-client.h>
#include <wayland-client-protocol.h>
#include "WLInterface.hpp"
#include "WLShellInterface.hpp"

namespace WaylandBackend
{

class WLShell : public WLShellInterface
{
public:
    WLShell(struct wl_event_queue *eventQ);
    virtual ~WLShell();

    int init(struct wl_registry* registry, uint32_t name,
             const char* interface, uint32_t version);
    uint32_t getWLID();
    std::string& getWLName();

    std::string& getShellName() { return _shellName; }

    int surfaceCreate(struct wl_surface* wlSurface, unsigned int surfaceId,
                      void **shellSurface);

    int surfaceDestroy(void *shellSurface);
    
    int surfaceSetTitle(void* shellSurface, const char *title);
    
    int surfaceSetClass(void* shellSurface, const char *surfClass);
    
    int surfaceSetAsPopup(void* shellSurface, struct wl_seat *seat,
                          uint32_t serial, struct wl_surface *parent,
                          int32_t x, int32_t y, uint32_t flags);
    
    int surfaceSetMaximized(void* shellSurface, struct wl_output *output);

    int surfaceSetFullScreen(void *shellSurface, uint32_t method,
                             uint32_t framerate, struct wl_output *output);
    
    int surfaceSetTransient(void *shellSurface, struct wl_surface *parent,
                            int32_t x, int32_t y, uint32_t flags);

    int surfaceSetTopLevel(void *shellSurface);
    
    int surfaceResize(void *shellSurface, struct wl_seat *seat, uint32_t serial,
                      uint32_t edges);

    int surfaceMove(void *shellSurface, struct wl_seat *seat, uint32_t serial);

    
private:
    struct wl_event_queue*      _wlEventQ;
    uint32_t                    _wlID;
    std::string                 _wlInterfaceName;
    struct wl_shell *           _wlShell;
    std::string                 _shellName;
    
    static const struct wl_shell_surface_listener surface_listener;
    
    static void handleSurfaceConfigure(void *data,
                             struct wl_shell_surface *wlShellSurface,
                             uint32_t edges,
                             int32_t width,
                             int32_t height);

    static void handleSurfacePing(void *data,
         	             struct wl_shell_surface *wl_shell_surface,
                         uint32_t serial);
		                     
    static void handleSurfacePopupDone(void *data,
			   struct wl_shell_surface *wl_shell_surface);

};

}

#endif
